<?php
	require 'include/lib.php';
?>
<!DOCTYPE html>
<html>
<?php include 'head.html'; ?>
<body>
	<?php include 'navbar.php'; ?>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<h1>ลูกค้า</h1>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<div class="panel panel-warning">
					<div class="panel-body">
						<form method="get" class="form-inline">
							<label for="">ชื่อลูกค้า</label>
							<input type="text" name="name" class="form-control" placeholder="ชื่อลูกค้า" value="<?=isset($_GET['name']) ? $_GET['name'] : '';?>">
							&emsp;
							<label for="">เบอร์โทรศัพท์</label>
							<input type="text" name="phone" class="form-control" placeholder="เบอร์โทรศัพท์" value="<?=isset($_GET['phone']) ? $_GET['phone'] : '';?>">
							<button class="btn btn-primary" type="submit">
								<i class="fa fa-search"></i>
								ค้นหา
							</button>
							<button type="button" class="btn btn-warning" onclick="window.location='<?=URL::to('customer.php');?>'">
								<i class="fa fa-undo"></i>
								ล้าง
							</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
				<table class="table table-hover b-table">
					<tr class="heading">
						<td class="center" colspan="6">
							<a href="<?=URL::to('customer-create.php')?>">
								<button class="btn btn-success">
									<i class="fa fa-plus"></i>
									เพิ่มลูกค้า
								</button>
							</a>
						</td>
					</tr>
					<tr class="heading">
						<th width="15%">#</th>
						<th width="35%">ลูกค้า</th>
						<th width="25%">สาขา</th>
						<th width="10%">ภาษี</th>
						<th width="15%" colspan="2">แก้ไข / ลบ</th>
					</tr>
					<?php
						$datas = Customer::lists();

						if(sizeof($datas) == 0) {
							echo '<tr class="heading">';
								echo '<td class="center" colspan="6">ไม่พบข้อมูลลูกค้าในระบบ</td>';
							echo '</tr>';
						}
						else {
							$cnt = 0;
							foreach ($datas as $key => $data) {
								echo '<tr>';
									echo '<td class="center">'.(++$cnt).'</td>';
									echo '<td>'.$data['name'].'</td>';
									echo '<td>'.$data['nickname'].'</td>';
									echo '<td class="center">'.($data['tax_value'] > 0 ? ($data['tax_value'] % 1 == 0 ? intval($data['tax_value']) : number_format($data['tax_value'], 2)).' %' : '-').'</td>';
									echo '<td class="center" width="7.5%">
										<i class="fa fa-edit fa-button"
											onclick="window.location=\''.URL::to('customer-update.php?id='.$data['id']).'\'"
										>
										</i>
									</td>';
									echo '<td class="center" width="7.5%">
										<i class="fa fa-trash fa-button"
											onclick="requestDelete('.$data['id'].')"
										>
										</i>
									</td>';
								echo '</tr>';
							}
						}
					?>
					<tr class="heading">
						<td class="center" colspan="6">
							<a href="<?=URL::to('customer-create.php')?>">
								<button class="btn btn-success">
									<i class="fa fa-plus"></i>
									เพิ่มลูกค้า
								</button>
							</a>
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
	<script type="text/javascript">
		function requestDelete(id) {
			if(confirm('ลบลูกค้า ?')) {
				window.location = '<?=URL::to('customer-delete.php?delete=true&id=')?>'+id;
			}
		}
	</script>
</body>
</html>
