<?php
/**
* @param $host : server name
* @param $username : connection username
* @param $password : connection password
* @param $dbname : database name
*/
class DB {
	/**
	* default database setting
	*/
	const HOST = 'localhost';
	const USER = 'cp572170_ud';
	const PASS = 'pOOh4558363';
	const DBNAME = 'cp572170_billing-system';

	public static $c; //connection

	public static $showSql = 0;

	public static function open($host=null, $username=null, $password=null, $dbname=null) {
		$host = isset($host)?$host:self::HOST;
		$username = isset($username)?$username:self::USER;
		$password = isset($password)?$password:self::PASS;
		$dbname = isset($dbname)?$dbname:self::DBNAME;
		self::$c = mysqli_connect($host, $username, $password, $dbname);

		if(!self::$c) {
			return false;
		}

		self::execute('SET character_set_connection=utf8, character_set_client=utf8, character_set_results=utf8;');
		return true;
	}

	public static function query($sql, $params=[], $escape=true) {
		if($escape) {
			foreach ($params as $key => $param) {
				$param = mysqli_real_escape_string(self::$c, $param);
				$sql = str_replace('{'.$key.'}', $param, $sql);
			}
		}

		if(self::$showSql) {
			echo '<pre>';
			print_r($sql);
			echo '</pre>';
		}

		$query = mysqli_query(self::$c, $sql);

		if(!$query) {
			return false;
		}

		$arr = [];
		while ($row = mysqli_fetch_assoc($query)) {
			array_push($arr, $row);
		}
		return $arr;
	}

	public static function execute($sql, $params=[], $escape=true) {
		if($escape) {
			foreach ($params as $key => $param) {
				$param = mysqli_real_escape_string(self::$c, $param);
				$sql = str_replace('{'.$key.'}', $param, $sql);
			}
		}

		if(self::$showSql) {
			echo '<pre>';
			print_r($sql);
			echo '</pre>';
		}

		if(!mysqli_query(self::$c, $sql)) {
			return false;
		}
		return true;
	}

	public static function close() {
		if(self::$c) {
			if(mysqli_close(self::$c)) {
				return true;
			}
		}
		return false;
	}

	public static function get_last_id() {
		$result = self::query('SELECT LAST_INSERT_ID()');
		if(sizeof($result) == 1 && isset($result[0]['LAST_INSERT_ID()']) && $result[0]['LAST_INSERT_ID()']) {
			return $result[0]['LAST_INSERT_ID()'];
		}
		return false;
	}

	public static function escape($param) {
		if(!is_string($param)){
			return $param;
		}
		return trim(mysqli_real_escape_string(self::$c, $param));
	}
}

/**
* using example
*/

// db::open();
// echo '<pre>';
// print_r( db::q('SELECT * FROM student '));
// echo '</pre>';
?>
