<?php
class ThaiDate
{
	public static function getTimeStamp() {
		return ''.(microtime(true)*10000);	
	}

	private static $thaiDay = [
		0 => ['abvt' => 'อา.', 'full' => 'อาทิตย์'],
		1 => ['abvt' => 'จ.', 'full' => 'จันทร์'],
		2 => ['abvt' => 'อ.', 'full' => 'อังคาร'],
		3 => ['abvt' => 'พ.', 'full' => 'พุธ'],
		4 => ['abvt' => 'พฤ.', 'full' => 'พฤหัสบดี'],
		5 => ['abvt' => 'ศ.', 'full' => 'ศุกร์'],
		6 => ['abvt' => 'ส.', 'full' => 'เสาร์'],
	];

	private static $thaiMonth = [
		1 => ['abvt' => 'ม.ค.', 'full' => 'มกราคม'],
		2 => ['abvt' => 'ก.พ.', 'full' => 'กุมภาพันธ์'],
		3 => ['abvt' => 'มี.ค.', 'full' => 'มีนาคม'],
		4 => ['abvt' => 'เม.ย.', 'full' => 'เมษายน'],
		5 => ['abvt' => 'พ.ค.', 'full' => 'พฤษภาคม'],
		6 => ['abvt' => 'มิ.ย.', 'full' => 'มิถุนายน'],
		7 => ['abvt' => 'ก.ค.', 'full' => 'กรกฎาคม'],
		8 => ['abvt' => 'ส.ค.', 'full' => 'สิงหาคม'],
		9 => ['abvt' => 'ก.ย.', 'full' => 'กันยายน'],
		10 => ['abvt' => 'ต.ค.', 'full' => 'ตุลาคม'],
		11 => ['abvt' => 'พ.ย.', 'full' => 'พฤศจิกายน'],
		12 => ['abvt' => 'ธ.ค.', 'full' => 'ธันวาคม']
	];

	public static function getDay($d, $full = true) {
		$d = intval($d);
		if($d < 0 || $d > 6) {
			return false;
		}
		return self::$thaiDay[$d][$full ? 'full' : 'abvt'];
	}

	public static function getMonth($m, $full = true) {
		$m = intval($m);
		if($m < 1 || $m > 12) {
			return false;
		}
		return self::$thaiMonth[$m][$full ? 'full' : 'abvt'];
	}

	public static function toThaiDate($dateValue = null, $format = null) {
		$format = $format == null ? 'วัน'.self::getDay(date('w')).' ที่ d m พ.ศ. Y เวลา H:i น.' : $format;
		$dateValue = $dateValue == null ? date('Y-m-d H:i:s') : $dateValue;
		$dateTime = explode(' ', $dateValue);

		$date = explode('-', $dateTime[0]);
		$time = explode(':', $dateTime[1]);

		$yearThai = (intval($date[0])+543);
		$shortMonthThai = self::getMonth($date[1], false);
		$fullMonthThai = self::getMonth($date[1]);
		$dateThai = intval($date[2]);
		$hourThai = $time[0];
		$minThai = str_pad($time[1], 2, 0, 0);
		$secThai = str_pad($time[2], 2, 0, 0);

		$format = str_replace('Y', $yearThai, $format);
		$format = str_replace('y', substr($yearThai, 2, 2), $format);
		$format = str_replace('M', $fullMonthThai, $format);
		$format = str_replace('m', $shortMonthThai, $format);
		$format = str_replace('d', $dateThai, $format);

		$format = str_replace('H', str_pad( $hourThai, 2, 0, 0 ), $format);
		$format = str_replace('h', str_pad( (intval($hourThai)%12), 2, 0, 0) , $format);
		$format = str_replace('i', $minThai, $format);
		$format = str_replace('s', $secThai, $format);
		
		return $format;
	}

	// public static function optionDays($select = 0){
	// 	$str = '<option disabled selected value="">วันที่</option>';
	// 	for($i = 1; $i < 32; ++$i){
	// 		$str .= '<option value="'.str_pad($i,2,0,STR_PAD_LEFT).'"'.($i==$select?' selected ': '').'>'.$i.'</option>';
	// 	}
	// 	return $str;
	// }

	// public static function optionMonths($select = 0){
	// 	$str = '<option disabled selected value="">เดือน</option>';
	// 	for($i = 1; $i < 13; ++$i){
	// 		$str .= '<option value="'.str_pad($i, 2, 0, STR_PAD_LEFT).'"'.($i==$select?' selected ': '').'>'.ThaiDate::getMonth($i).'</option>';
	// 	}
	// 	return $str;
	// }
}
?>
