<?php
if($_SERVER['SCRIPT_NAME']=='/include/wb.php')exit();
class WB
{
	public static function getAllPosts($start = 0, $count = 10){
		$posts = DB::q('SELECT
			post_id,
			post_title,
			post_text,
			IFNULL(post_update_datetime, post_create_datetime) AS post_datetime,
			post_by,
			(
				CASE 1 
				WHEN user_type = 1 THEN
					user_username
				WHEN user_type = 2 THEN
					CONCAT(user_name, " ", user_lastname)
				WHEN post_by = 0 THEN
					"เจ้าหน้าที่"
				ELSE 
					"ผู้ถูกระงับหรือลบบัญชี"
				END
			) AS user_show_name,
			user_pic_path,
			post_views,
			(SELECT COUNT(*) FROM comments WHERE comments.post_id = posts.post_id) AS post_comments
		FROM
			posts
		LEFT JOIN users ON(posts.post_by = users.user_id)
		ORDER BY
			IFNULL(post_update_datetime, post_create_datetime) DESC
		LIMIT '.$start.', '.$count);
		if(!$posts)return false;
		return $posts;
	}

	public static function insertPost(){
		if(!isset($_POST['post-title'])||trim($_POST['post-title'])==''){
			return false;
		}
		if(!isset($_POST['post-text'])||trim($_POST['post-text'])==''){
			return false;
		}

		$postBy = User::getCurrentUserId();

		if($postBy===false){
			return false;
		}

		$postTitle = trim($_POST['post-title']);
		$postText = trim($_POST['post-text']);
		

		$sql = 'INSERT INTO posts(
			post_title, post_text, post_create_datetime, post_by
		) VALUES (
			"{title}", "{text}", NOW(), "{by}"
		)';

		$q = DB::exc($sql,
		[
			'title'=>$postTitle,
			'text'=>$postText,
			'by'=>$postBy
		]);

		if(!$q)return false;

		$postId = DB::getLastId();

		if( sizeof($_FILES) > 0 && isset($_FILES['post-file']['tmp_name']) && trim($_FILES['post-file']['tmp_name']) != ''){
			$f = self::uploadPostFile(ThaiDate::getTimeStamp());
			if(!$f){
				self::deletePost($postId);
				return false;
			}
			$f = PATH::$FILEPOST.$f;
			if(!self::updatePostFile($postId, $f, trim($_FILES['post-file']['name'] ) )) {
				self::unlinkPostFile($f);
				return false;
			}
		}
		return true;
	}

	private static function unlinkPostFile($fn){
		if(!file_exists($fn))return false;
		if(!unlink($fn))return false;
		return true;
	}

	private static function uploadPostFile($timeStamp){
		$f = FileManager::requestFile('post-file');
		if(!$f){
			return false;
		}
		return FileManager::uploadFile($f, PATH::$FILEPOST_REAL, $timeStamp);
	}

	private static function updatePostFile($postId, $f ,$fn){
		$sql = 'UPDATE posts SET post_file = "{f}", post_file_name = "{fn}" WHERE post_id = {post_id}';
		$q = DB::exc($sql, ['post_id'=>$postId, 'f'=>$f, 'fn'=>$fn]);
		if(!$q)return false;
		return true;
	}

	public static function deletePost($postId){
		if(!self::isPostEditable($postId))return false;
		$sql = 'DELETE FROM posts WHERE post_id = {post_id}';
		$q = DB::exc($sql, ['post_id'=>$postId]);
		if(!$q)return false;
		return true;
	}

	public static function updatePost(){

		if(!isset($_POST['post-id'])||intval($_POST['post-id'])<=0) {
			return false;
		}

		if(self::isPostEditable(intval($_POST['post-id']))!=2)return false;

		if(!isset($_POST['post-title'])||trim($_POST['post-title'])==''){
			return false;
		}
		if(!isset($_POST['post-text'])||trim($_POST['post-text'])==''){
			return false;
		}

		$postId = intval($_POST['post-id']);
		$postTitle = trim($_POST['post-title']);
		$postText = trim($_POST['post-text']);
		
		$delPostFile = ( isset($_POST['delete-post-file']) && trim($_POST['delete-post-file'])=='dpf' ? ', post_file = NULL, post_file_name = NULL ' : '' );

		$sql = 'UPDATE posts
		SET	
			post_title = "{title}",
			post_text = "{text}", 
			post_update_datetime = NOW()
			{postfile}
		WHERE 
			post_id = {post_id}';

		$q = DB::exc($sql, [
			'title'=>$postTitle, 
			'text'=>$postText, 
			'post_id'=>$postId,
			'postfile'=>$delPostFile
		]);

		if( sizeof($_FILES) > 0 && isset($_FILES['post-file']['tmp_name']) && trim($_FILES['post-file']['tmp_name']) != ''){
			$f = self::uploadPostFile(ThaiDate::getTimeStamp());
			if(!$f){
				
			}else{
				$f = PATH::$FILEPOST.$f;
				if(!self::updatePostFile($postId, $f, trim($_FILES['post-file']['name'] ) )){
					return false;
				}
			}
			
		}
		return true;

	}

	public static function isMyPost($postId){
		$myPost = DB::q('SELECT 1 FROM posts WHERE post_id = {post_id} AND post_by = {post_by} AND post_by IS NOT NULL LIMIT 1',['post_id'=>$postId, 'post_by'=>User::getCurrentUserId()]);
		if($myPost)return true;
		return false;
	}

	public static function isPostEditable($postId){
		if(self::isMyPost($postId))return 2;
		if(User::isAdmin())return 1;
		return false;
	}

	public static function isMyComment($commentId){
		$myComment = DB::q('SELECT 1 FROM comments WHERE comment_id = {comment_id} AND comment_by = {comment_by} AND comment_by IS NOT NULL LIMIT 1',['comment_id'=>$commentId, 'comment_by'=>User::getCurrentUserId()]);
		if($myComment)return true;
		return false;
	}

	public static function isCommentEditable($commentId){
		if(self::isMyComment($commentId))return 2;
		if(User::isAdmin())return 1;
		return false;
	}

	public static function readPost($postId){
		if(!is_numeric($postId)){
			return false;
		}

		if(!User::islogin() || !self::isMyPost($postId)){
			$sql = 'UPDATE posts SET post_views = (post_views+1) WHERE post_id = {post_id}';
			$stat = DB::exc($sql, ['post_id'=>$postId]);
			if(!$stat){
				return false;
			}
		}

		$post = DB::q('SELECT
			post_id,
			post_title,
			post_text,
			IFNULL(post_update_datetime, post_create_datetime) AS post_datetime,
			post_by,
			(
				CASE 1 
				WHEN user_type = 1 THEN
					user_username
				WHEN user_type = 2 THEN
					CONCAT(user_name, " ", user_lastname)
				WHEN post_by = 0 THEN
					"เจ้าหน้าที่"
				ELSE 
					"ผู้ถูกระงับหรือลบบัญชี"
				END
			) AS user_show_name,
			user_pic_path,
			post_views,
			(SELECT COUNT(*) FROM comments WHERE comments.post_id = posts.post_id) AS post_comments,
			post_file,
			post_file_name
		FROM
			posts
		LEFT JOIN users ON(posts.post_by = users.user_id)
		WHERE post_id = {post_id}
		LIMIT 1',
		['post_id'=>$postId]);

		if(!$post)return false;
		return $post[0];
	}

	public static function insertComment(){
		if(!isset($_POST['comment-text'])||trim($_POST['comment-text'])==''){
			return false;
		}
		if(!isset($_POST['post-id'])||intval($_POST['post-id'])<=0){
			return false;
		}
		$sql = 'INSERT INTO comments(
			comment_text, 
			comment_create_datetime, 
			comment_by, 
			post_id
		) VALUES(
			"{cm_text}",
			NOW(),
			{cm_by},
			{post_id}
		)';
		$stat = DB::exc($sql, ['cm_text'=>self::encodeText($_POST['comment-text']), 'cm_by'=>User::getCurrentUserId(), 'post_id'=>intval($_POST['post-id'])]);
		if(!$stat)return false;
		return true;
	}

	public static function deleteComment($commentId){
		if(!self::isCommentEditable($commentId))return false;
		$sql = 'DELETE FROM comments WHERE comment_id = {comment_id}';
		$q = DB::exc($sql, ['comment_id'=>$commentId]);
		if(!$q)return false;
		return true;
	}

	public static function updateComment(){
		if(!isset($_POST['comment-id'])||intval($_POST['comment-id'])<=0) {
			return false;
		}

		if(self::isCommentEditable(intval($_POST['comment-id']))!=2)return false;

		if(!isset($_POST['comment-text'])||trim($_POST['comment-text'])==''){
			return false;
		}

		$sql = 'UPDATE comments
		SET	
			comment_text = "{text}", 
			comment_update_datetime = NOW()
		WHERE 
			comment_id = {comment_id}';

		$q = DB::exc($sql, [
			'text'=>trim($_POST['comment-text']), 
			'comment_id'=>intval($_POST['comment-id'])

		]);
	

		if(!$q)return false;
		return true;
	}

	public static function getAllComments($postId){
		$comments = DB::q('SELECT
			comment_id,
			comment_text,
			comment_create_datetime,
			comment_by,
			(
				CASE 1 
				WHEN user_type = 1 THEN
					user_username
				WHEN user_type = 2 THEN
					CONCAT(user_name, " ", user_lastname)
				WHEN comment_by = 0 THEN
					"เจ้าหน้าที่"
				ELSE 
					"ผู้ถูกระงับหรือลบบัญชี"
				END
			) AS user_show_name,
			user_pic_path
		FROM
			comments
		LEFT JOIN users ON(comments.comment_by = users.user_id)
		WHERE post_id = {post_id}
		ORDER BY
			comment_create_datetime',
		['post_id'=>$postId]);
		if(sizeof($comments)==0)return false;
		return $comments;
	}

	private static function encodeText($str){
		return preg_replace( '/\r\n|\r|\n/' , '<br/>' , htmlentities( trim($str) ) );
	}

	

}
function capturePost(){
	if(isset($_POST['insert-post']) && isset($_POST['post-title']) && isset($_POST['post-text'])){
		if(!WB::insertPost()){
			URL::redirect('error.php');
		}
		URL::redirect('webboard-all.php');
	}

	if(isset($_POST['post-id']) && intval($_POST['post-id'])>0 && isset($_POST['update-post']) && isset($_POST['post-title']) && isset($_POST['post-text'])){
		if(!WB::updatePost()){
			URL::redirect('error.php');
		}
		URL::redirect('webboard-detail.php?post_id='.$_POST['post-id']);
	}




	if( isset($_POST['insert-comment']) && isset($_POST['comment-text']) && isset($_POST['post-id']) ){
		if(!WB::insertComment()){
			URL::redirect('error.php');
		}
		URL::redirect('webboard-detail.php?post_id='.$_POST['post-id']);
	}

	if( isset($_POST['update-comment']) && isset($_POST['comment-text']) && isset($_POST['comment-id']) && isset($_POST['p-id']) && intval($_POST['p-id'])>0 ){
		if(!WB::updateComment()){
			
			URL::redirect('error.php');
		}
	
		URL::redirect('webboard-detail.php?post_id='.intval($_POST['p-id']));
	}
}

function capturePostDelete(){
	if( isset($_GET['post_id']) && intval($_GET['post_id'])>0) {
		if(!WB::deletePost($_GET['post_id'])){
			URL::redirect('error.php?การลบกระทู้ผิดพลาด หรือคุณไม่มีสิทธิ์ลบกระทู้นี้');
		}
		URL::redirect('webboard-all.php');
	}

	if( isset($_GET['comment_id']) && intval($_GET['comment_id'])>0 && isset($_GET['p_id']) && intval($_GET['p_id'])>0) {
		if(!WB::deleteComment($_GET['comment_id'])){
			URL::redirect('error.php?การลบความคิดเห็นผิดพลาด หรือคุณไม่มีสิทธิ์ลบความคิดเห็นนี้');
		}
		URL::redirect('webboard-detail.php?post_id='.intval($_GET['p_id']));
	}
}