<?php
	require 'include/lib.php';

	if(!isset($_POST['product']) || !sizeof($_POST['product'])) {
		HTML::script('alert("ไม่พบข้อมูล");window.close();');
		URL::redirect('product.php');
	}
	
	$title = 'Products';
?>
<!DOCTYPE html>
<html>
<?php include 'head-print.html'; ?>
<body>
	<table width="100%">
		<tr>
			<th width="30%" class="center bdt bdl bdr bdb">บาร์โค้ด</th>
			<th width="40%" class="center bdt bdr bdb">ชื่อสินค้า</th>
			<th width="30%" class="center bdt bdr bdb">ราคา</th>
		</tr>
		<?php
			foreach ($_POST['product'] as $key => $value) {
				$product = Product::detail($key);
				echo '<tr>';
					echo '<td class="center bdl bdr bdb">
						<svg
							class="barcode"
							jsbarcode-format="EAN13"
							jsbarcode-value="'.$product['barcode'].'"
							jsbarcode-width="1.5"
							jsbarcode-height="40"
							jsbarcode-textmargin="0"
							jsbarcode-background="transparent"
						></svg>
					</td>';
					echo '<td class="bdr bdb">'.$product['name'].'</td>';
					echo '<td class="right bdr bdb">'.number_format($product['price'] ,2).'</td>';
				echo '</tr>';
			}
		?>
	</table>
	<script type="text/javascript">
		$().ready(function(){
			JsBarcode('.barcode').init();
			$('.barcode').show();
			window.print();
			setTimeout(function(){
				window.close();
			}, 1);
		});
	</script>
</body>
</html>
