<?php
	require 'include/lib.php';
?>
<!DOCTYPE html>
<html>
<?php include 'head.html'; ?>
<body>
	<?php include 'navbar.php'; ?>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<h1>จัดการสินค้า</h1>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<div class="panel panel-warning">
					<div class="panel-body">
						<form method="get" class="form-inline">
							<label for="">รหัสสินค้า</label>
							<input type="text" name="barcode" class="form-control center" maxlength="13" placeholder="รหัสสินค้า" value="<?=isset($_GET['barcode']) ? $_GET['barcode'] : '';?>">
							&emsp;
							<label for="">ชื่อสินค้า</label>
							<input type="text" name="name" class="form-control" placeholder="ชื่อสินค้า" value="<?=isset($_GET['name']) ? $_GET['name'] : '';?>">
							<button class="btn btn-primary" type="submit">
								<i class="fa fa-search"></i>
								ค้นหา
							</button>
							<button type="button" class="btn btn-warning" onclick="window.location='<?=URL::to('product.php');?>'">
								<i class="fa fa-undo"></i>
								ล้าง
							</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
				<form target="_blank" method="post" action="<?=URL::to('product-print.php')?>">
					<table class="table table-hover b-table">
						<tr class="heading">
							<td class="center" colspan="7">
								<a href="<?=URL::to('product-create.php')?>">
									<button type="button" class="btn btn-success">
										<i class="fa fa-plus"></i>
										เพิ่มสินค้า
									</button>
								</a>
								<button type="submit" class="btn btn-primary print-product">
									<i class="fa fa-barcode"></i>
									พิมพ์บาร์โค้ด
								</button>
							</td>
						</tr>
						<tr class="heading">
							<th width="10%"><input id="select-all" type="checkbox" data-toggle="toggle" data-style="invoice-number" data-size="small" data-on="เลือกทั้งหมด" data-off="ไม่เลือก" data-onstyle="success" data-offstyle="danger" checked/></th>
							<th width="7%">#</th>
							<th width="15%">รหัสสินค้า</th>
							<th width="43%">ชื่อสินค้า</th>
							<th width="15%">ราคา</th>
							<th width="20%" colspan="2">แก้ไข / ลบ</th>
						</tr>
						<?php
							$datas = Product::lists();

							if(sizeof($datas) == 0) {
								echo '<tr class="heading">';
									echo '<td class="center" colspan="7">ไม่พบข้อมูลสินค้าในระบบ</td>';
								echo '</tr>';
							}
							else {
								$cnt = 0;
								foreach ($datas as $key => $data) {
									echo '<tr>';
										echo '<th><input class="check-product" name="product['.$data['id'].']" type="checkbox" data-toggle="toggle" data-style="invoice-number" data-size="small" data-on="<i class=\'fa fa-check\'></i>" data-off="<i class=\'fa fa-close\'>" data-onstyle="success" checked/></th>';
										echo '<td class="center">'.++$cnt.'</td>';
										echo '<td class="center">
											<svg
												class="barcode"
												jsbarcode-format="EAN13"
												jsbarcode-value="'.$data['barcode'].'"
												jsbarcode-width="1.5"
												jsbarcode-height="40"
												jsbarcode-textmargin="0"
												jsbarcode-background="transparent"
											></svg>
										</td>';
										echo '<td>'.$data['name'].'</td>';
										echo '<td class="right">'.number_format($data['price'] ,2).'</td>';
										echo '<td class="center" width="10%">
											<i class="fa fa-edit fa-button" 
												onclick="window.location=\''.URL::to('product-update.php?id='.$data['id']).'\'"
											>
											</i>
										</td>';
										echo '<td class="center" width="10%">
											<i class="fa fa-trash fa-button"
												onclick="requestDelete('.$data['id'].')"
											>
											</i>
										</td>';
									echo '</tr>';
								}
							}
						?>
						<tr class="heading">
							<td class="center" colspan="7">
								<a href="<?=URL::to('product-create.php')?>">
									<button type="button" class="btn btn-success">
										<i class="fa fa-plus"></i>
										เพิ่มสินค้า
									</button>
								</a>
								<button type="submit" class="btn btn-primary print-product">
									<i class="fa fa-barcode"></i>
									พิมพ์บาร์โค้ด
								</button>
							</td>
						</tr>
					</table>
				</form>
			</div>
		</div>
	</div>
	<script type="text/javascript">
		function requestDelete(id) {
			if(confirm('ลบสินค้า ?')) {
				window.location = '<?=URL::to('product-delete.php?delete=true&id=')?>'+id;
			}
		}

		function checkPrint() {
			if($('.check-product:checked').length == 0) {
				$('.print-product').attr('disabled', 'disabled');
				return;
			}
			else {
				$('.print-product').removeAttr('disabled');
			}
		}

		$(document).ready(function() {
			JsBarcode('.barcode').init();
			$('.barcode').show();

			$('.check-product').change(function() {
				checkPrint();
			});


			$('#select-all').change(function() {
				$('.check-product').bootstrapToggle($(this).prop('checked') ? 'on' : 'off');
				checkPrint();
			});

			checkPrint();

		});
	</script>
</body>
</html>